﻿<#
.SYNOPSIS
This script connects to Microsoft Graph GCC-High and then creates a service principal
for all of the missing endpoints required for CMMC Level 2 Enclave Build.

.DESCRIPTION
This PowerShell script uses the Microsoft Graph PowerShell SDK to:
1. Install MgGraph if not present
2. Authenticate with Microsoft Graph using specific permissions against M365 GCC-High Tenant
2. Create the missing service principals used for specific MS Portals.

.SERVICE PRINCIPALS
19db86c3-b2b9-44cc-b339-36da233a3be2 (My Access)
8c59ead7-d703-4a27-9e55-c96a0054c8d2 (my Profile)
1b912ec3-a9dd-4c4d-a53e-76aa7adb28d7 (AADReporting)
62060984-07ca-4b01-802e-d9c0e90718d8 (Microsoft Command Device Graph Service)
d9ccafc4-e937-4c21-8218-704028037e40 (Office365 Shell WCSS-Server)

Version 1.0

Author: Casey Lang (Stratus Cyber)
#>

# Install MgGraph for usage
Install-Module -Name Microsoft.Graph

# Connect to Microsoft Graph with required scopes
Connect-MgGraph -Environment USGov -Scopes Directory.ReadWrite.All, Application.ReadWrite.All

# Create the service principals for the granular portal areas or APIs.
New-MgServicePrincipal -Appid '19db86c3-b2b9-44cc-b339-36da233a3be2'
New-MgServicePrincipal -Appid '8c59ead7-d703-4a27-9e55-c96a0054c8d2'
New-MgServicePrincipal -Appid '1b912ec3-a9dd-4c4d-a53e-76aa7adb28d7'
New-MgServicePrincipal -Appid '62060984-07ca-4b01-802e-d9c0e90718d8'
New-MgServicePrincipal -Appid 'd9ccafc4-e937-4c21-8218-704028037e40'